/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Map;
import org.drools.core.util.DateUtils;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulator;

public class DateFieldPopulator
extends FieldPopulator {
    private final Date value;

    public DateFieldPopulator(Object factObject, Class<?> fieldClass, String fieldName, String value) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        super(factObject, fieldName);
        this.value = this.createTimeObject(fieldClass, value);
    }

    private Date createTimeObject(Class<?> fieldClass, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class[] parameterTypes = new Class[]{Long.TYPE};
        Constructor<?> constructor = fieldClass.getConstructor(parameterTypes);
        Object[] args = new Object[]{this.getTimeAsLong(value)};
        return (Date)constructor.newInstance(args);
    }

    private long getTimeAsLong(String value) {
        return DateUtils.parseDate(value, null).getTime();
    }

    @Override
    public void populate(Map<String, Object> populatedData) {
        this.populateField(this.value, populatedData);
    }
}

